﻿using System.Collections.Generic;
using System.ComponentModel;
using System;
using System.Collections.ObjectModel;
using BMSConfigurationWarlock.Base;
using System.IO;
using System.Linq;

namespace BMSConfigurationWarlock
{
    public class MainWindowModel : INotifyPropertyChanged, IMessageModel
    {
        private GeneralConfigurationModel generalConfiguration;
        private string searchServicesLocation;
        private string searchSiteLocation;
        
        public GeneralConfigurationModel GeneralConfiguration
        {
            get { return generalConfiguration; }
            set
            {
                if (generalConfiguration != value)
                {
                    generalConfiguration = value;
                    NotifyPropertyChanged(NameOf<MainWindowModel>.Property(e => e.GeneralConfiguration));
                }
            }
        }

        public string SearchServicesLocation
        {
            get { return searchServicesLocation; }
            set
            {
                if (searchServicesLocation != value)
                {
                    searchServicesLocation = value;
                    NotifyPropertyChanged(NameOf<MainWindowModel>.Property(e => e.SearchServicesLocation));
                }
            }
        }

        public string SearchSiteLocation
        {
            get { return searchSiteLocation; }
            set
            {
                if (searchSiteLocation != value)
                {
                    searchSiteLocation = value;
                    NotifyPropertyChanged(NameOf<MainWindowModel>.Property(e => e.SearchSiteLocation));
                }
            }
        }

        public int ServiceOperationTimeOutSeconds;

        private string siteAssemblyPath;

        public string SiteAssemblyPath
        {
            get { return siteAssemblyPath; }
            set
            {
                if (siteAssemblyPath != value)
                {
                    siteAssemblyPath = value;
                    NotifyPropertyChanged(NameOf<MainWindowModel>.Property(e => e.SiteAssemblyPath));
                    NotifyPropertyChanged(NameOf<MainWindowModel>.Property(e => e.SiteConfigPath));
                }
            }
        }

        public string SiteConfigPath
        {
            get 
            {
                try
                {
                    DirectoryInfo info = new DirectoryInfo(Path.GetDirectoryName(SiteAssemblyPath));
                    return Path.Combine(info.Parent.FullName, Constants.WebConfig);
                }
                catch { return String.Empty; }
            }
        }
        

        private ObservableCollection<ServiceConfiguration> serviceConfigurationCollection;
        public ObservableCollection<ServiceConfiguration> ServiceConfigurationCollection 
        {
            get { return serviceConfigurationCollection; }
            set
            {
                if (serviceConfigurationCollection != value)
                {
                    serviceConfigurationCollection = value;
                    NotifyPropertyChanged(NameOf<MainWindowModel>.Property(e => e.ServiceConfigurationCollection));
                }
            }
        }

        private NotifyOnElementChangedObservableCollection<DatabaseConfiguration> databaseConfigurationCollection;

        public NotifyOnElementChangedObservableCollection<DatabaseConfiguration> DatabaseConfigurationCollection
        {
            get { return databaseConfigurationCollection; }
            set
            {
                if (databaseConfigurationCollection != value)
                {
                    databaseConfigurationCollection = value;
                    NotifyPropertyChanged(NameOf<MainWindowModel>.Property(e => e.DatabaseConfigurationCollection));
                }
            }
        }

        private string databaseNamePattern;
        public string DatabaseNamePattern
        {
            get { return databaseNamePattern; }
            set
            {
                if (databaseNamePattern != value)
                {
                    databaseNamePattern = value;
                    NotifyPropertyChanged(NameOf<MainWindowModel>.Property(e => e.DatabaseNamePattern));
                }
            }
        }

        private string messages;
        public string Messages
        {
            get { return messages; }
            set
            {
                if (messages != value)
                {
                    messages = value;
                    NotifyPropertyChanged(NameOf<MainWindowModel>.Property(e => e.Messages));
                }
            }
        }

        private bool databaseConnectionsChecked = false;
        private bool servicesConfigFilesLoaded = false;
        private bool servicesConfigFilesModified = false;

        public bool ServicesConfigFilesLoaded
        {
            get { return servicesConfigFilesLoaded; }
            set
            {
                if (servicesConfigFilesLoaded != value)
                {
                    servicesConfigFilesLoaded = value;
                    NotifyPropertyChanged(NameOf<MainWindowModel>.Property(e => e.ServicesConfigFilesLoaded));
                }
            }
        }

        public bool ServicesConfigFilesModified
        {
            get { return servicesConfigFilesModified; }
            set
            {
                if (servicesConfigFilesModified != value)
                {
                    servicesConfigFilesModified = value;
                    NotifyPropertyChanged(NameOf<MainWindowModel>.Property(e => e.ServicesConfigFilesModified));
                }
            }
        }

        public bool DatabaseConnectionsChecked
        {
            get { return databaseConnectionsChecked; }
            set
            {
                if (databaseConnectionsChecked != value)
                {
                    databaseConnectionsChecked = value;
                    NotifyPropertyChanged(NameOf<MainWindowModel>.Property(e => e.DatabaseConnectionsChecked));
                }
            }
        }

        private bool siteConfigFileLoaded = false;
        private bool siteConfigFileModified = false;

        public bool SiteConfigFileLoaded
        {
            get { return siteConfigFileLoaded; }
            set
            {
                if (siteConfigFileLoaded != value)
                {
                    siteConfigFileLoaded = value;
                    NotifyPropertyChanged(NameOf<MainWindowModel>.Property(e => e.SiteConfigFileLoaded));
                }
            }
        }

        public bool SiteConfigFileModified
        {
            get { return siteConfigFileModified; }
            set
            {
                if (siteConfigFileModified != value)
                {
                    siteConfigFileModified = value;
                    NotifyPropertyChanged(NameOf<MainWindowModel>.Property(e => e.SiteConfigFileModified));
                }
            }
        }

        private string reportsUserDomain;

        public string ReportsUserDomain
        {
            get { return reportsUserDomain; }
            set
            {
                if (reportsUserDomain != value)
                {
                    reportsUserDomain = value;
                    NotifyPropertyChanged(NameOf<MainWindowModel>.Property(e => e.ReportsUserDomain));
                }
            }
        }

        private string reportsUserName;

        public string ReportsUserName
        {
            get { return reportsUserName; }
            set
            {
                if (reportsUserName != value)
                {
                    reportsUserName = value;
                    NotifyPropertyChanged(NameOf<MainWindowModel>.Property(e => e.ReportsUserName));
                }
            }
        }

        private string reportsUserPassword;

        public string ReportsUserPassword
        {
            get { return reportsUserPassword; }
            set
            {
                if (reportsUserPassword != value)
                {
                    reportsUserPassword = value;
                    NotifyPropertyChanged(NameOf<MainWindowModel>.Property(e => e.ReportsUserPassword));
                }
            }
        }

        private string reportingServicesUrl;

        public string ReportingServicesUrl
        {
            get { return reportingServicesUrl; }
            set
            {
                if (reportingServicesUrl != value)
                {
                    reportingServicesUrl = value;
                    NotifyPropertyChanged(NameOf<MainWindowModel>.Property(e => e.ReportingServicesUrl));
                }
            }
        }

        private string reportsRootFolder;

        public string ReportsRootFolder
        {
            get { return reportsRootFolder; }
            set
            {
                if (reportsRootFolder != value)
                {
                    reportsRootFolder = value;
                    NotifyPropertyChanged(NameOf<MainWindowModel>.Property(e => e.ReportsRootFolder));
                }
            }
        }
        

        private ObservableCollection<SqlScript> sqlScriptCollection;

        public ObservableCollection<SqlScript> SqlScriptCollection
        {
            get { return sqlScriptCollection; }
            set
            {
                if (sqlScriptCollection != value)
                {
                    sqlScriptCollection = value;
                    NotifyPropertyChanged(NameOf<MainWindowModel>.Property(e => e.SqlScriptCollection));
                }
            }
        }

        private ObservableCollection<DatabaseConfiguration> variables;
        public ObservableCollection<DatabaseConfiguration> Variables
        {
            get 
            {
                return variables;
            }
            set
            {
                if (variables != value)
                {
                    variables = value;
                    NotifyPropertyChanged(NameOf<MainWindowModel>.Property(e => e.Variables));
                }
            }
        }

        public bool SqlScriptsExist
        {
            get
            {
                if (SqlScriptCollection == null || SqlScriptCollection.Count == 0)
                    return false;
                return true;
            }
        }

        private string applicationDomain;

        public string ApplicationDomain
        {
            get
            {
                return applicationDomain;
            }
            set
            {
                if (applicationDomain != value)
                {
                    applicationDomain = value;
                    NotifyPropertyChanged(NameOf<MainWindowModel>.Property(e => e.ApplicationDomain));
                }
            }
        }

        private string superUsers;

        public string SuperUsers
        {
            get
            {
                return superUsers;
            }
            set
            {
                if (superUsers != value)
                {
                    superUsers = value;
                    NotifyPropertyChanged(NameOf<MainWindowModel>.Property(e => e.SuperUsers));
                }
            }
        }
        
        

        public int HttpsPortOffset;

        #region INotifyPropertyChanged

        public event PropertyChangedEventHandler PropertyChanged;

        private void NotifyPropertyChanged(String info)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(info));
            }
        }

        #endregion
    }
}
